:- module(pro_fadd, [ init_accent/3,
		      init_dict/3,
		      init_morph/6,
		      init_tuple/2,
		      accent_word/3,
		      prefix_word/3,
		      morph_word/3,
		      guess_word/3,
		      number_word/3,
		      word_tuple_grams/3,
		      word_tuple_fpgrams/3,
		      close_accent/2,
		      close_dict/2,
		      close_tuple/2,
		      fadd_get_errno/1
		    ]). 

foreign_resource(pro_fadd, [init_accent, init_dict, init_morph, pro_init_tuple,
			    pro_accent_word, pro_prefix_word, pro_morph_word,
			    pro_guess_word,
			    number_word, pro_word_tuple_grams, 
                                         pro_word_tuple_fpgrams,close_accent,
			    close_dict, close_tuple, fadd_get_errno,
			    pro_restore_lib_state,
			    init(fadd_init_hook),deinit(fadd_deinit_hook)]).

foreign(pro_restore_lib_state, c, pro_restore_lib_state(+string, [-integer])).

foreign(init_accent, c, init_accent0(+string, +integer, [-integer])).

foreign(init_dict, c, init_dict0(+string, +integer, [-integer])).

foreign(init_morph, c,
	init_morph0(+string, +integer, +integer, +integer, +integer,
		   [-integer])).

foreign(init_guess, c,
	init_guess0(+string, +integer, +integer, +integer, +integer,
		   [-integer])).

foreign(pro_init_tuple, c, init_tuple0(+term, [-integer])).

foreign(pro_accent_word, c, accent_word(+string, +integer, [-term])).

foreign(pro_prefix_word, c, prefix_word0(+string, +integer, [-term])).

foreign(pro_morph_word, c, morph_word(+string, +integer, [-term])).

foreign(pro_guess_word, c, guess_word(+string, +integer, [-term])).

foreign(number_word, c, number_word(+string, +integer, [-integer])).

foreign(pro_word_tuple_grams, c, word_tuple_grams(+term, +integer, [-term])).

foreign(pro_word_tuple_fpgrams, c, word_tuple_fpgrams(+term, +integer, [-term])).

foreign(close_accent, c, close_accent0(+integer, [-integer])).

foreign(close_dict, c, close_dict0(+integer, [-integer])).

foreign(close_tuple, c, close_tuple0(+integer, [-integer])).

foreign(fadd_get_errno, c, fadd_get_errno([-integer])).

:- dynamic save_lib_state/1.
:- public save_dictionaries/1, restore_dictionaries/0.  % from C

close_dict(C,O) :-
    close_dict0(C,O).

close_accent(C,O) :-
    close_accent0(C,O).

close_tuple(C,O) :-
    close_tuple0(C,O).

save_dictionaries(String) :-
    assertz(save_lib_state(String)).

%% nb. you can't raise an exception here, since it's called from C
restore_dictionaries :-
    (	retract(save_lib_state(String))
    ->	pro_restore_lib_state(String,Int),
	(   Int > 0
	->  format(user_error,
		   "ERROR (fadd): restoring dictionary: ~w~n",[Int])
	;   true
	)
    ;	format(user_error,
	       "ERROR (fadd): could not retract save_lib_state/1!~n",[])
    ).

init_accent(File0,Type,Dict) :-
    absolute_file_name(File0,File),
    init_accent0(File,Type,Dict),
    check_error(Dict,init_accent(File,Type,Dict)).

init_dict(File0,Type,Dict) :-
    absolute_file_name(File0,File),
    init_dict0(File,Type,Dict),
    check_error(Dict,init_dict(File,Type,Dict)).

init_morph(File0,T1,T2,T3,T4,Dict) :-
    absolute_file_name(File0,File),
    init_morph0(File,T1,T2,T3,T4,Dict),
    check_error(Dict,init_morph(File,T1,T2,T3,T4,Dict)).

init_guess(File0,T1,T2,T3,T4,Dict) :-
    absolute_file_name(File0,File),
    init_guess0(File,T1,T2,T3,T4,Dict),
    check_error(Dict,init_guess(File,T1,T2,T3,T4,Dict)).

init_tuple(FileList0,Dict) :-
    absolute_file_name_list(FileList0,FileList),
    init_tuple0(FileList,Dict),
    check_error(Dict,init_tuple(FileList,Dict)).

absolute_file_name_list([],[]).
absolute_file_name_list([H0|T0],[H|T]) :-
    absolute_file_name(H0,H),
    absolute_file_name_list(T0,T).

check_error(Dict,Goal) :-
    (	Dict == -1
    ->	fadd_get_errno(Err),
	raise_exception(fadd_error("~w (error no: ~w)~n",[Goal,Err]))
    ;	true
    ).

prefix_word(Atom,DictNo,Prefix) :-
    prefix_word0(Atom,DictNo,[Prefix]).

:- load_foreign_resource(pro_fadd).

:- multifile user:portray_message/2.
user:portray_message(error,fadd_error(Term,Args)):-
    !,
    format(user_error,"** error in fadd library: ",[]),
    format(user_error,Term,Args).

