/***	py_fadd.cc	***/
/*
 *	Python wrapper for fadd.
 */

/*
Command to build a Python module:
g++ -O3 -Wall -shared -std=c++11 -fPIC `python3 -m pybind11 --includes` -I /usr/include/python3.10 -I .  py_fadd.cc -o pyfadd`python3.10-config --extension-suffix` -L. -lfadd -Wl,-rpath,.
Replace 3.10 with your Python version
 */
#include	<pybind11/pybind11.h>
#include	"fadd.h"

PYBIND11_MODULE(pyfadd, m) {
  m.doc() = "Finite state dictionary library"; // module docstring
  m.def("fadd_init_lib", &fadd_init_lib,
	"Initializes the library (allocates memory for bookkeeping).");
  m.def("init_dict", &init_dict,
	"Initializes a dictionary of strings.");
  m.def("init_morph", &init_morph,
	"Initializes a morphological dictionary.");
  m.def("number_word", &number_word,
	"Finds a number associated with the argument word in the dictionary.");
  m.def("word_number", &word_number,
	"Finds a word associated in the dictionary with the argument number.");
  m.def("morph_word", &morph_word,
	"Finds all morphological analyses of the argument word.");
  m.def("close_dict", &close_dict,
	"Removes the dictionary from memory.");
  m.def("fadd_close_lib", &fadd_close_lib,
	"Releases memory held by the library.");
}
/***	EOF py_fadd.cc	***/
